require("stategraphs/commonstates")

local actionhandlers =
{
    ActionHandler(ACTIONS.GOHOME, "action"),
}

local events=
{
    EventHandler("attacked", function(inst) if not inst.components.health:IsDead() and not inst.sg:HasStateTag("attack") then inst.sg:GoToState("hit") end end),
    EventHandler("death", function(inst) inst.sg:GoToState("death") end),
    EventHandler("doattack", function(inst, data) if not inst.components.health:IsDead() and (inst.sg:HasStateTag("hit") or not inst.sg:HasStateTag("busy")) then inst.sg:GoToState("attack", data.target) end end),
    CommonHandlers.OnLocomote(true, false),
}

local function GetVolume(inst)
	if inst.components.transparentonsanity then
		return inst.components.transparentonsanity:GetPercent()
	end
	return 1
end

local states=
{

 State{
        
        name = "idle",
        tags = {"idle", "canrotate"},
        onenter = function(inst, playanim)
            inst.Physics:Stop()
            if playanim then
                inst.AnimState:PlayAnimation(playanim)
                inst.AnimState:PushAnimation("idle")
            else
                inst.AnimState:PlayAnimation("idle")
            end
        end,
        
        timeline = 
        {
		    --TimeEvent(7*FRAMES, function(inst) inst:PushEvent("wingdown")  end ),
            --TimeEvent(17*FRAMES, function(inst) inst:PushEvent("wingdown")  end ),
        },
        
        events=
        {
            EventHandler("animover", function(inst) inst.sg:GoToState("idle") end),
        },
    },
	
    State{
        name = "attack",
        tags = {"attack", "busy"},

        onenter = function(inst, target)
            inst.sg.statemem.target = target
            inst.Physics:Stop()
            inst.components.combat:StartAttack()
            inst.AnimState:PlayAnimation("atk")
            inst.AnimState:PushAnimation("atk", false)
            inst.SoundEmitter:PlaySound(inst.sounds.attack_grunt, nil, GetVolume(inst))
        end,

        timeline=
        {
			--[[TimeEvent(11*FRAMES, function(inst) 
				inst.components.combat:DoAttack()
				inst:PushEvent("wingdown")
				end),]]
			TimeEvent(14*FRAMES, function(inst) inst.SoundEmitter:PlaySound(inst.sounds.attack, nil, GetVolume(inst)) end),
			TimeEvent(24*FRAMES, function(inst) inst.components.combat:DoAttack(inst.sg.statemem.target) end),
			
        },

        events=
        {
            EventHandler("animqueueover", function(inst)
                if math.random() < .333 then
                    inst.components.combat:SetTarget(nil)
                    inst.sg:GoToState("taunt")
                else
                    inst.sg:GoToState("idle")
                end
            end),
        },
    },

	State{
		name = "hit",
        tags = {"busy", "hit"},

        onenter = function(inst)
            inst.Physics:Stop()
            inst.AnimState:PlayAnimation("hit")
			SpawnPrefab("statue_transition_2").Transform:SetPosition(inst:GetPosition():Get())
        end,

        events=
        {
			EventHandler("animover", function(inst)
                if GetWorld().Map then
                
					local max_tries = 4
					for k = 1,max_tries do
						local pos = Vector3(inst.Transform:GetWorldPosition())
						local offset = 10
						pos.x = pos.x + (math.random(2*offset)-offset)          
						pos.z = pos.z + (math.random(2*offset)-offset)
						if GetWorld().Map:GetTileAtPoint(pos:Get()) ~= GROUND.IMPASSABLE then
							inst.Transform:SetPosition(pos:Get() )
							break
						end
					end
                end

				inst.sg:GoToState("appear")
                
			end),
			
        },
    },

	State{
		name = "taunt",
        tags = {"busy"},

        onenter = function(inst)
            inst.Physics:Stop()
            inst.AnimState:PlayAnimation("staff")
            inst.SoundEmitter:PlaySound(inst.sounds.taunt, nil, GetVolume(inst))
        end,

		--timeline=
        --{
			--TimeEvent(13*FRAMES, function(inst)  end),
        --},

        events=
        {
			EventHandler("animover", function(inst) inst.sg:GoToState("idle") end),
        },
    },
    
    State{
        name = "appear",
        tags = {"busy"},
        
        onenter = function(inst)
            inst.AnimState:PlayAnimation("hit")
			SpawnPrefab("statue_transition_2").Transform:SetPosition(inst:GetPosition():Get())
            inst.Physics:Stop()
            inst.SoundEmitter:PlaySound(inst.sounds.appear, nil, GetVolume(inst))
        end,
        
        events = 
        {
            EventHandler("animover", function(inst) inst.sg:GoToState("idle") end)
        },
    },

    State{
        name = "death",
        tags = {"busy"},

        onenter = function(inst)
			inst.SoundEmitter:PlaySound(inst.sounds.death, nil, GetVolume(inst))
            inst.AnimState:Hide("swap_arm_carry")
            inst.AnimState:PlayAnimation("death")
			SpawnPrefab("statue_transition_2").Transform:SetPosition(inst:GetPosition():Get())
            inst.Physics:Stop()
            RemovePhysicsColliders(inst)            
            inst.components.lootdropper:DropLoot(Vector3(inst.Transform:GetWorldPosition()))            
        end,


    },
    
	State{
        name = "disappear",
        tags = {"busy"},

        onenter = function(inst)
			inst.persists = false
			inst.SoundEmitter:PlaySound(inst.sounds.death, nil, GetVolume(inst))
            inst.AnimState:PlayAnimation("hit")
			SpawnPrefab("statue_transition_2").Transform:SetPosition(inst:GetPosition():Get())
            inst.Physics:Stop()
        end,
        
        events =
        {
            EventHandler("animover", function(inst) 
				inst:Remove()
			end ),
        },        
    },   

    State{
        
        name = "action",
        onenter = function(inst, playanim)
            inst.Physics:Stop()
            inst:PerformBufferedAction()
        end,
        
        events = 
        {
            EventHandler("animover", function(inst) inst.sg:GoToState("idle") end)
        },
    },

State{
        name = "run_start",
        tags = {"moving", "running", "canrotate"},
        
        onenter = function(inst)
			inst.components.locomotor:RunForward()
            inst.AnimState:PlayAnimation("run_pre")
            inst.sg.mem.foosteps = 0
        end,

        onupdate = function(inst)
            inst.components.locomotor:RunForward()
        end,

        events=
        {   
            EventHandler("animover", function(inst) inst.sg:GoToState("run") end ),        
        },
        
        timeline=
        {
        
            --[[TimeEvent(4*FRAMES, function(inst)
                PlayFootstep(inst)
                DoFoleySounds(inst)
            end),]]
        },        
        
    },

    State{
        
        name = "run",
        tags = {"moving", "running", "canrotate"},
        
        onenter = function(inst) 
            inst.components.locomotor:RunForward()
            inst.AnimState:PlayAnimation("run_loop")
            
        end,
        
        onupdate = function(inst)
            inst.components.locomotor:RunForward()
        end,

        timeline=
        {
            --[[TimeEvent(7*FRAMES, function(inst)
				inst.sg.mem.foosteps = inst.sg.mem.foosteps + 1
                PlayFootstep(inst, inst.sg.mem.foosteps < 5 and 1 or .6)
                DoFoleySounds(inst)
            end),
            TimeEvent(15*FRAMES, function(inst)
				inst.sg.mem.foosteps = inst.sg.mem.foosteps + 1
                PlayFootstep(inst, inst.sg.mem.foosteps < 5 and 1 or .6)
                DoFoleySounds(inst)
            end),]]
        },
        
        events=
        {   
            EventHandler("animover", function(inst) inst.sg:GoToState("run") end ),        
        },
        
        
    },
    
    State{
    
        name = "run_stop",
        tags = {"canrotate", "idle"},
        
        onenter = function(inst) 
            inst.components.locomotor:Stop()
            inst.AnimState:PlayAnimation("run_pst")
        end,
        
        events=
        {   
            EventHandler("animover", function(inst) inst.sg:GoToState("idle") end ),        
        },
        
    },    	
}

return StateGraph("shadowcreature", states, events, "appear", actionhandlers)